### Introduction

This Code of Conduct applies to all spaces managed by the Gravity Recovery Object Oriented Programming System (GROOPS) project, including all public and private mailing lists, issue trackers, discussions, wikis, blogs, meetings, workshops and any other channel used by our community.

This Code of Conduct should be honored by everyone who participates in the GROOPS community formally or informally, or claims any affiliation with the project, in any project-related activities and especially when representing the project, in any role.

This code is not exhaustive or complete. It serves to distill our common understanding of a collaborative, shared environment and goals. Please try to follow this code in spirit as much as in letter, to create a friendly and productive environment that enriches the surrounding community.

### Specific Guidelines

We strive to:

1. Be open. We invite anyone to participate in our community. We prefer to use public methods of communication for project-related messages, unless discussing something sensitive. This applies to messages for help or project-related support, too; not only is a public support request much more likely to result in an answer to a question, it also ensures that any inadvertent mistakes in answering are more easily detected and corrected.
2. Be empathetic, welcoming, friendly, and patient. We work together to resolve conflict, and assume good intentions. We may all experience some frustration from time to time, but we do not allow frustration to turn into a personal attack. A community where people feel uncomfortable or threatened is not a productive one. Most project members answer questions or investigate issues in their spare time, so be patient when waiting for a response.
3. Be collaborative. Our work will be used by other people, and in turn we will depend on the work of others. When we make something for the benefit of the project, we are willing to explain to others how it works, so that they can build on the work to make it even better. Any decision we make will affect users and colleagues, and we take those consequences seriously when making decisions.
4. Be inquisitive. Nobody knows everything! Asking questions early avoids many problems later, so we encourage questions, although we may direct them to the appropriate forum. We will try hard to be responsive and helpful.
5. Be careful in the words that we choose. We are careful and respectful in our communication, and we take responsibility for our own speech. Be kind to others. Do not insult or put down other participants. We will not accept harassment or other exclusionary behaviour, such as:
   * Violent threats or language directed against another person.
   * Sexist, racist, or otherwise discriminatory jokes and language.
   * Posting sexually explicit or violent material.
   * Posting (or threatening to post) other people’s personally identifying information (“doxing”).
   * Sharing private content, such as emails sent privately or non-publicly, without the sender’s consent.
   * Personal insults, especially those using racist or sexist terms.
   * Unwelcome sexual attention.
   * Excessive profanity. Please avoid swearwords; people differ greatly in their sensitivity to swearing.
   * Repeated harassment of others. In general, if someone asks you to stop, then stop.
   * Advocating for, or encouraging, any of the above behaviour.

### Diversity Statement

The GROOPS project welcomes and encourages participation by everyone. No matter how you identify yourself or how others perceive you: we welcome you. We are committed to being a community that everyone enjoys being part of. Although we may not always be able to accommodate each individual’s preferences, we try our best to treat everyone kindly.

Though no list can hope to be comprehensive, we explicitly honour diversity in: age, culture, ethnicity, genotype, gender identity or expression, language, national origin, neurotype, phenotype, political beliefs, profession, race, religion, sexual orientation, socioeconomic status, subculture and technical ability, to the extent that these do not conflict with this Code of Conduct.

### Enforcement and Reporting Guidelines

We encourage all community members to resolve issues on their own whenever possible. Instances of abusive, harassing, or otherwise unacceptable behavior may be reported to the [project committee](https://github.com/orgs/groops-devs/people).

In case of severe and obvious breaches, we will immediately disconnect the originator from the GROOPS communication channels. In cases not involving clear severe and obvious breaches of this Code of Conduct, the process for acting on any received Code of Conduct violation report will be:

1. Acknowledgement that the report has been received
2. Reasonable discussion/feedback
3. Mediation (if feedback didn’t help, and only if both reporter and reportee agree to this)
4. Enforcement via transparent decision by the [project committee](https://github.com/orgs/groops-devs/people) leading to one of the following resolutions:
   1. Correction

      A private, written warning from community leaders, providing clarity around the nature of the violation and an explanation of why the behavior was inappropriate. A public apology may be requested.
   2. Warning

      Consequence: A warning with consequences for continued behavior. No interaction with the people involved, including unsolicited interaction with those enforcing the Code of Conduct, for a specified period of time. This includes avoiding interactions in community spaces as well as external channels like social media. Violating these terms may lead to a temporary or permanent ban.
   3. Temporary Ban

      Consequence: A temporary ban from any sort of interaction or public communication with the community for a specified period of time. No public or private interaction with the people involved, including unsolicited interaction with those enforcing the Code of Conduct, is allowed during this period. Violating these terms may lead to a permanent ban.
   4. Permanent Ban

      Consequence: A permanent ban from any sort of public interaction within the community.

### Attribution

This Code of Conduct is adapted from the [SciPy Code of Conduct](https://docs.scipy.org/doc/scipy/dev/conduct/code_of_conduct.html), the [Microsoft Open Source Code of Conduct](https://opensource.microsoft.com/codeofconduct/) and the [Contributor Covenant Code of Conduct](https://www.contributor-covenant.org/version/2/1/code_of_conduct/).
