from _typeshed import Incomplete
from asyncio.base_events import Server
from asyncio.events import AbstractEventLoop
from typing import NoReturn

from gunicorn.asgi.lifespan import LifespanManager
from gunicorn.config import Config
from gunicorn.glogging import Logger as GLogger
from gunicorn.workers import base

from .._types import _ASGIAppType

class ASGIWorker(base.Worker):
    worker_connections: int
    loop: AbstractEventLoop | None
    servers: list[Server]
    nr_conns: int
    lifespan: LifespanManager | None
    state: dict[Incomplete, Incomplete]
    asgi: _ASGIAppType

    @classmethod
    def check_config(cls, cfg: Config, log: GLogger) -> None: ...
    def init_process(self) -> None: ...
    def load_wsgi(self) -> None: ...
    def init_signals(self) -> None: ...
    def handle_quit_signal(self) -> None: ...
    def handle_exit_signal(self) -> None: ...
    def handle_usr1_signal(self) -> None: ...
    def handle_winch_signal(self) -> None: ...
    def handle_abort_signal(self) -> NoReturn: ...
    def run(self) -> None: ...
