from collections.abc import Callable

class BaseServer:
    SIGNATURE_METHODS: dict[str, Callable[..., bool]]
    SUPPORTED_SIGNATURE_METHODS: list[str]
    EXPIRY_TIME: int
    @classmethod
    def register_signature_method(cls, name: str, verify: Callable[..., bool]) -> None: ...
    def validate_timestamp_and_nonce(self, request) -> None: ...
    def validate_oauth_signature(self, request) -> None: ...
    def get_client_by_id(self, client_id): ...
    def exists_nonce(self, nonce, request) -> bool: ...
