from _typeshed import Incomplete, ReadableBuffer
from collections.abc import Iterable
from typing import ClassVar, Final, SupportsBytes, SupportsIndex

from authlib.jose.rfc7516 import JWEAlgorithm

from .ec_key import ECKey
from .oct_key import OctKey
from .rsa_key import RSAKey

class DirectAlgorithm(JWEAlgorithm):
    name: str
    description: str
    def prepare_key(self, raw_data) -> OctKey: ...
    def generate_preset(self, enc_alg, key) -> dict[Incomplete, Incomplete]: ...
    def wrap(self, enc_alg, headers, key, preset=None) -> dict[str, Incomplete]: ...
    def unwrap(self, enc_alg, ek, headers, key): ...

class RSAAlgorithm(JWEAlgorithm):
    key_size: int
    name: str
    description: str
    padding: Incomplete
    def __init__(self, name: str, description: str, pad_fn) -> None: ...
    def prepare_key(self, raw_data) -> RSAKey: ...
    def generate_preset(self, enc_alg, key) -> dict[str, Incomplete]: ...
    def wrap(self, enc_alg, headers, key, preset=None) -> dict[str, Incomplete]: ...
    def unwrap(self, enc_alg, ek, headers, key): ...

class AESAlgorithm(JWEAlgorithm):
    name: str
    description: str
    key_size: int
    def __init__(self, key_size: int) -> None: ...
    def prepare_key(self, raw_data) -> OctKey: ...
    def generate_preset(self, enc_alg, key) -> dict[str, Incomplete]: ...
    def wrap_cek(self, cek, key) -> dict[str, Incomplete]: ...
    def wrap(self, enc_alg, headers, key, preset=None) -> dict[str, Incomplete]: ...
    def unwrap(self, enc_alg, ek, headers, key) -> bytes: ...

class AESGCMAlgorithm(JWEAlgorithm):
    EXTRA_HEADERS: ClassVar[Iterable[str]]
    name: str
    description: str
    key_size: int
    def __init__(self, key_size: int) -> None: ...
    def prepare_key(self, raw_data) -> OctKey: ...
    def generate_preset(self, enc_alg, key) -> dict[str, Incomplete]: ...
    def wrap(self, enc_alg, headers, key, preset=None) -> dict[str, Incomplete]: ...
    def unwrap(self, enc_alg, ek, headers, key) -> bytes: ...

class ECDHESAlgorithm(JWEAlgorithm):
    EXTRA_HEADERS: ClassVar[Iterable[str]]
    ALLOWED_KEY_CLS = Incomplete
    name: str
    description: str
    key_size: int | None
    aeskw: AESAlgorithm
    def __init__(self, key_size: int | None = None) -> None: ...
    def prepare_key(self, raw_data) -> ECKey: ...
    def generate_preset(self, enc_alg, key) -> dict[str, Incomplete]: ...
    def compute_fixed_info(self, headers, bit_size) -> bytes: ...
    def compute_derived_key(self, shared_key, fixed_info, bit_size) -> bytes: ...
    def deliver(self, key, pubkey, headers, bit_size) -> bytes: ...
    def wrap(self, enc_alg, headers, key, preset=None) -> dict[str, Incomplete]: ...
    def unwrap(self, enc_alg, ek, headers, key) -> bytes: ...

def u32be_len_input(
    s: str | bytes | float | Iterable[SupportsIndex] | SupportsIndex | SupportsBytes | ReadableBuffer, base64: bool = False
) -> bytes: ...

JWE_ALG_ALGORITHMS: Final[list[JWEAlgorithm]]
