from _typeshed import Incomplete
from abc import ABCMeta
from collections.abc import Iterable, Sized
from typing import ClassVar
from typing_extensions import Self

class JWEAlgorithmBase(metaclass=ABCMeta):
    EXTRA_HEADERS: ClassVar[Iterable[str] | None]
    name: str | None
    description: str | None
    algorithm_type: str
    algorithm_location: str
    def prepare_key(self, raw_data): ...
    def generate_preset(self, enc_alg, key): ...

class JWEAlgorithm(JWEAlgorithmBase, metaclass=ABCMeta):
    def wrap(self, enc_alg, headers, key, preset=None): ...
    def unwrap(self, enc_alg, ek, headers, key): ...

class JWEAlgorithmWithTagAwareKeyAgreement(JWEAlgorithmBase, metaclass=ABCMeta):
    def generate_keys_and_prepare_headers(self, enc_alg, key, sender_key, preset=None): ...
    def agree_upon_key_and_wrap_cek(self, enc_alg, headers, key, sender_key, epk, cek, tag): ...
    def wrap(self, enc_alg, headers, key, sender_key, preset=None): ...
    def unwrap(self, enc_alg, ek, headers, key, sender_key, tag=None): ...

class JWEEncAlgorithm:
    name: str | None
    description: str | None
    algorithm_type: str
    algorithm_location: str
    IV_SIZE: int | None
    CEK_SIZE: int | None
    def generate_cek(self) -> bytes: ...
    def generate_iv(self) -> bytes: ...
    def check_iv(self, iv: Sized) -> None: ...
    def encrypt(self, msg, aad, iv, key) -> tuple[bytes, bytes]: ...
    def decrypt(self, ciphertext, aad, iv, tag, key) -> bytes: ...

class JWEZipAlgorithm:
    name: Incomplete
    description: Incomplete
    algorithm_type: str
    algorithm_location: str
    def compress(self, s: bytes) -> bytes | None: ...
    def decompress(self, s: bytes) -> bytes | None: ...

class JWESharedHeader(dict[str, object]):
    protected: Incomplete
    unprotected: Incomplete
    def __init__(self, protected, unprotected) -> None: ...
    def update_protected(self, addition) -> None: ...
    @classmethod
    def from_dict(cls, obj) -> Self: ...

class JWEHeader(dict[str, object]):
    protected: Incomplete
    unprotected: Incomplete
    header: Incomplete
    def __init__(self, protected, unprotected, header) -> None: ...
