from _typeshed import Incomplete, ReadableBuffer
from collections import OrderedDict
from collections.abc import Iterable
from typing import SupportsBytes, SupportsIndex

from .models import JWEAlgorithmBase, JWEEncAlgorithm, JWEZipAlgorithm

class JsonWebEncryption:
    REGISTERED_HEADER_PARAMETER_NAMES: frozenset[str]
    ALG_REGISTRY: dict[str, JWEAlgorithmBase]
    ENC_REGISTRY: dict[str, JWEEncAlgorithm]
    ZIP_REGISTRY: dict[str, JWEZipAlgorithm]
    def __init__(self, algorithms=None, private_headers=None) -> None: ...
    @classmethod
    def register_algorithm(cls, algorithm: JWEAlgorithmBase | JWEEncAlgorithm | JWEZipAlgorithm) -> None: ...
    def serialize_compact(self, protected, payload, key, sender_key=None) -> bytes: ...
    def serialize_json(self, header_obj, payload, keys, sender_key=None) -> OrderedDict[Incomplete, Incomplete]: ...
    def serialize(self, header, payload, key, sender_key=None) -> OrderedDict[Incomplete, Incomplete] | bytes: ...
    def deserialize_compact(
        self,
        s: str | bytes | float | Iterable[SupportsIndex] | SupportsIndex | SupportsBytes | ReadableBuffer,
        key,
        decode=None,
        sender_key=None,
    ) -> dict[str, Incomplete]: ...
    def deserialize_json(self, obj, key, decode=None, sender_key=None) -> dict[str, Incomplete]: ...
    def deserialize(self, obj, key, decode=None, sender_key=None) -> dict[str, Incomplete]: ...
    @staticmethod
    def parse_json(obj) -> dict[Incomplete, Incomplete]: ...
    def get_header_alg(self, header) -> JWEAlgorithmBase: ...
    def get_header_enc(self, header) -> JWEEncAlgorithm: ...
    def get_header_zip(self, header) -> JWEZipAlgorithm: ...

def prepare_key(alg, header, key): ...
