from _typeshed import Incomplete, ReadableBuffer
from collections.abc import Iterable
from typing import SupportsBytes, SupportsIndex

from .models import JWSAlgorithm, JWSObject

class JsonWebSignature:
    REGISTERED_HEADER_PARAMETER_NAMES: frozenset[str]
    MAX_CONTENT_LENGTH: int
    ALGORITHMS_REGISTRY: dict[str, JWSAlgorithm]
    def __init__(self, algorithms=None, private_headers=None) -> None: ...
    @classmethod
    def register_algorithm(cls, algorithm: JWSAlgorithm) -> None: ...
    def serialize_compact(self, protected, payload, key) -> bytes: ...
    def deserialize_compact(
        self, s: str | bytes | float | Iterable[SupportsIndex] | SupportsIndex | SupportsBytes | ReadableBuffer, key, decode=None
    ) -> JWSObject: ...
    def serialize_json(self, header_obj, payload, key) -> dict[str, Incomplete]: ...
    def deserialize_json(self, obj, key, decode=None) -> JWSObject: ...
    def serialize(self, header, payload, key) -> dict[str, Incomplete] | bytes: ...
    def deserialize(self, s, key, decode=None) -> JWSObject: ...
