## 1.5.8.7 (2023-07-05)

Mark `types-typed-ast` as no longer updated ([#10410](https://github.com/python/typeshed/pull/10410))

## 1.5.8.6 (2023-03-28)

Add defaults for third-party stubs Q-T ([#9959](https://github.com/python/typeshed/pull/9959))

## 1.5.8.5 (2023-03-11)

typed_ast: Add missing field to `typed_ast.ast3.TypeIgnore` ([#9868](https://github.com/python/typeshed/pull/9868))

```pycon
>>> import typed_ast.ast3 as ast3
>>> x = ast3.parse('def foo(): ... # type: ignore[attr-defined]')
>>> ast3.dump(x)
"Module(body=[FunctionDef(name='foo', args=arguments(args=[], vararg=None, kwonlyargs=[], kw_defaults=[], kwarg=None, defaults=[]), body=[Expr(value=Ellipsis())], decorator_list=[], returns=None, type_comment=None)], type_ignores=[TypeIgnore(lineno=1, tag='[attr-defined]')])"
```

## 1.5.8.4 (2023-02-21)

Stubtest settings: change `ignore_missing_stub` default to `false` ([#9779](https://github.com/python/typeshed/pull/9779))

If you're reading about this commit from an autogenerated changelog entry, this should have no user-visible impact on how the stubs are interpreted by a type checker; it's just an internal change to how typeshed's tests work.

## 1.5.8.3 (2022-11-14)

Improve `ast` types; revert several "redundant numeric union" changes from #7906 ([#9130](https://github.com/python/typeshed/pull/9130))

* Adapt number types in ast

Since mypy  0.990 type promotions was limited.
This means that complex is not longer promoted to int/float, therefore
we should adapt the types to list all possible types

Co-authored-by: pre-commit-ci[bot] <66853113+pre-commit-ci[bot]@users.noreply.github.com>
Co-authored-by: AlexWaygood <alex.waygood@gmail.com>

## 1.5.8.2 (2022-11-07)

Mark typed_ast as completed ([#9121](https://github.com/python/typeshed/pull/9121))

## 1.5.8.1 (2022-10-28)

typed-ast: fix get_docstring, allow buffer ([#9019](https://github.com/python/typeshed/pull/9019))

## 1.5.8 (2022-08-29)

`typed_ast.ast3`: `arguments.kw_defaults` should be `list[expr | None]` ([#8645](https://github.com/python/typeshed/pull/8645))

```python
>>> from typed_ast import ast3
>>> print(ast3.dump(ast3.parse('def foo(*, arg: int) -> None: ...')))
Module(body=[FunctionDef(name='foo', args=arguments(args=[], vararg=None, kwonlyargs=[arg(arg='arg', annotation=Name(id='int', ctx=Load()), type_comment=None)], kw_defaults=[None], kwarg=None, defaults=[]), body=[Expr(value=Ellipsis())], decorator_list=[], returns=NameConstant(value=None), type_comment=None)], type_ignores=[])
```

This bug was discovered in https://github.com/python/mypy/pull/13547

## 1.5.7 (2022-07-19)

Third-party stubs: enforce CamelCase for type alias names ([#8256](https://github.com/python/typeshed/pull/8256))

Co-authored-by: Jelle Zijlstra <jelle.zijlstra@gmail.com>

## 1.5.6 (2022-05-26)

Third-party stubs: fix several fictitious type aliases ([#7958](https://github.com/python/typeshed/pull/7958))

## 1.5.5 (2022-05-21)

Simplify and correct many numeric unions ([#7906](https://github.com/python/typeshed/pull/7906))

Unblocks PyCQA/flake8-pyi#222

## 1.5.4 (2022-04-20)

Use `TypeAlias` for type aliases where possible, part II ([#7667](https://github.com/python/typeshed/pull/7667))

## 1.5.3 (2022-04-16)

Third-party stubs: import from `collections.abc` where possible ([#7637](https://github.com/python/typeshed/pull/7637))

## 1.5.1 (2021-12-28)

Use PEP 585 syntax wherever possible ([#6717](https://github.com/python/typeshed/pull/6717))

## 1.5.0 (2021-11-12)

Bump typed-ast version, recommend Python 3.8 for tests ([#6278](https://github.com/python/typeshed/pull/6278))

## 1.4.5 (2021-10-12)

Add star to all non-0.1 versions ([#6146](https://github.com/python/typeshed/pull/6146))

