#### Note: this error code is no longer emitted by the compiler

This is because it was too specific to the `optimize` attribute.
Similar diagnostics occur for other attributes too.
The example here will now emit `E0539`

The `optimize` attribute was malformed.

Erroneous code example:

```compile_fail,E0539
#![feature(optimize_attribute)]

#[optimize(something)] // error: invalid argument
pub fn something() {}
```

The `#[optimize]` attribute should be used as follows:

- `#[optimize(size)]` -- instructs the optimization pipeline to generate code
  that's smaller rather than faster

- `#[optimize(speed)]` -- instructs the optimization pipeline to generate code
  that's faster rather than smaller

For example:

```
#![feature(optimize_attribute)]

#[optimize(size)]
pub fn something() {}
```

See [RFC 2412] for more details.

[RFC 2412]: https://rust-lang.github.io/rfcs/2412-optimize-attr.html
