% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R, R/print.compare_parameters.R,
%   R/print_html.R, R/print_md.R
\name{format.compare_parameters}
\alias{format.compare_parameters}
\alias{print.compare_parameters}
\alias{print_html.compare_parameters}
\alias{print_md.compare_parameters}
\title{Print comparisons of model parameters}
\usage{
\method{format}{compare_parameters}(
  x,
  split_components = TRUE,
  select = NULL,
  digits = 2,
  ci_digits = digits,
  p_digits = 3,
  ci_width = NULL,
  ci_brackets = NULL,
  zap_small = FALSE,
  format = NULL,
  groups = NULL,
  ...
)

\method{print}{compare_parameters}(
  x,
  split_components = TRUE,
  caption = NULL,
  subtitle = NULL,
  footer = NULL,
  digits = 2,
  ci_digits = digits,
  p_digits = 3,
  zap_small = FALSE,
  groups = NULL,
  column_width = NULL,
  ci_brackets = c("[", "]"),
  select = NULL,
  ...
)

\method{print_html}{compare_parameters}(
  x,
  caption = NULL,
  subtitle = NULL,
  footer = NULL,
  digits = 2,
  ci_digits = digits,
  p_digits = 3,
  zap_small = FALSE,
  groups = NULL,
  select = NULL,
  ci_brackets = c("(", ")"),
  font_size = "100\%",
  line_padding = 4,
  column_labels = NULL,
  ...
)

\method{print_md}{compare_parameters}(
  x,
  digits = 2,
  ci_digits = digits,
  p_digits = 3,
  caption = NULL,
  subtitle = NULL,
  footer = NULL,
  select = NULL,
  split_components = TRUE,
  ci_brackets = c("(", ")"),
  zap_small = FALSE,
  groups = NULL,
  ...
)
}
\arguments{
\item{x}{An object returned by \code{\link[=compare_parameters]{compare_parameters()}}.}

\item{split_components}{Logical, if \code{TRUE} (default), For models with
multiple components (zero-inflation, smooth terms, ...), each component is
printed in a separate table. If \code{FALSE}, model parameters are printed
in a single table and a \code{Component} column is added to the output.}

\item{select}{Determines which columns and and which layout columns are
printed. There are three options for this argument:
\itemize{
\item \strong{Selecting columns by name or index}

\code{select} can be a character vector (or numeric index) of column names that
should be printed, where columns are extracted from the data frame returned
by \code{model_parameters()} and related functions.

There are two pre-defined options for selecting columns:
\code{select = "minimal"} prints coefficients, confidence intervals and
p-values, while \code{select = "short"} prints coefficients, standard errors and
p-values.
\item \strong{A string expression with layout pattern}

\code{select} is a string with "tokens" enclosed in braces. These tokens will be
replaced by their associated columns, where the selected columns will be
collapsed into one column. Following tokens are replaced by the related
coefficients or statistics: \code{{estimate}}, \code{{se}}, \code{{ci}} (or \code{{ci_low}} and
\code{{ci_high}}), \code{{p}} and \code{{stars}}. The token \code{{ci}} will be replaced by
\verb{\{ci_low\}, \{ci_high\}}. Example: \code{select = "{estimate}{stars} ({ci})"}

It is possible to create multiple columns as well. A \code{|} separates values
into new cells/columns. Example: \code{select = "{estimate} ({ci})|{p}"}.

If \code{format = "html"}, a \verb{<br>} inserts a line break inside a cell. See
'Examples'.
\item \strong{A string indicating a pre-defined layout}

\code{select} can be one of the following string values, to create one of the
following pre-defined column layouts:
\itemize{
\item \code{"ci"}: Estimates and confidence intervals, no asterisks for p-values.
This is equivalent to \code{select = "{estimate} ({ci})"}.
\item \code{"se"}: Estimates and standard errors, no asterisks for p-values. This is
equivalent to \code{select = "{estimate} ({se})"}.
\item \code{"ci_p"}: Estimates, confidence intervals and asterisks for p-values. This
is equivalent to \code{select = "{estimate}{stars} ({ci})"}.
\item \code{"se_p"}: Estimates, standard errors and asterisks for p-values. This is
equivalent to \code{select = "{estimate}{stars} ({se})"}..
\item \code{"ci_p2"}: Estimates, confidence intervals and numeric p-values, in two
columns. This is equivalent to \code{select = "{estimate} ({ci})|{p}"}.
\item \code{"se_p2"}: Estimate, standard errors and numeric p-values, in two columns.
This is equivalent to \code{select = "{estimate} ({se})|{p}"}.
}
}

For \code{model_parameters()}, glue-like syntax is still experimental in the
case of more complex models (like mixed models) and may not return expected
results.}

\item{digits, ci_digits, p_digits}{Number of digits for rounding or
significant figures. May also be \code{"signif"} to return significant
figures or \code{"scientific"} to return scientific notation. Control the
number of digits by adding the value as suffix, e.g. \code{digits = "scientific4"}
to have scientific notation with 4 decimal places, or \code{digits = "signif5"}
for 5 significant figures (see also \code{\link[=signif]{signif()}}).}

\item{ci_width}{Minimum width of the returned string for confidence
intervals. If not \code{NULL} and width is larger than the string's length,
leading whitespaces are added to the string. If \code{width="auto"}, width
will be set to the length of the longest string.}

\item{ci_brackets}{Logical, if \code{TRUE} (default), CI-values are
encompassed in square brackets (else in parentheses).}

\item{zap_small}{Logical, if \code{TRUE}, small values are rounded after
\code{digits} decimal places. If \code{FALSE}, values with more decimal
places than \code{digits} are printed in scientific notation.}

\item{format}{Name of output-format, as string. If \code{NULL} (or \code{"text"}),
returned output is used for basic printing. Can be one of \code{NULL} (the
default) resp. \code{"text"} for plain text, \code{"markdown"} (or \code{"md"}) for
markdown and \code{"html"} for HTML output. A special option is \code{"tt"}, which
creates a \code{\link[tinytable:tt]{tinytable::tt()}} object, where the output format is dependent
on the context where the table is used, i.e. it can be markdown format when
\code{export_table()} is used in markdown files, or LaTeX format when creating
PDFs etc.}

\item{groups}{Named list, can be used to group parameters in the printed output.
List elements may either be character vectors that match the name of those
parameters that belong to one group, or list elements can be row numbers
of those parameter rows that should belong to one group. The names of the
list elements will be used as group names, which will be inserted as "header
row". A possible use case might be to emphasize focal predictors and control
variables, see 'Examples'. Parameters will be re-ordered according to the
order used in \code{groups}, while all non-matching parameters will be added
to the end.}

\item{...}{Arguments passed down to \code{\link[=format.parameters_model]{format.parameters_model()}},
\code{\link[insight:format_table]{insight::format_table()}} and \code{\link[insight:export_table]{insight::export_table()}}}

\item{caption}{Table caption as string. If \code{NULL}, depending on the model,
either a default caption or no table caption is printed. Use \code{caption = ""}
to suppress the table caption.}

\item{subtitle}{Table title (same as caption) and subtitle, as strings. If \code{NULL},
no title or subtitle is printed, unless it is stored as attributes (\code{table_title},
or its alias \code{table_caption}, and \code{table_subtitle}). If \code{x} is a list of
data frames, \code{caption} may be a list of table captions, one for each table.}

\item{footer}{Can either be \code{FALSE} or an empty string (i.e. \code{""}) to
suppress the footer, \code{NULL} to print the default footer, or a string. The
latter will combine the string value with the default footer.}

\item{column_width}{Width of table columns. Can be either \code{NULL}, a named
numeric vector, or \code{"fixed"}. If \code{NULL}, the width for each table column is
adjusted to the minimum required width. If a named numeric vector, value
names are matched against column names, and for each match, the specified
width is used. If \code{"fixed"}, and table is split into multiple components,
columns across all table components are adjusted to have the same width.}

\item{font_size}{For HTML tables, the font size.}

\item{line_padding}{For HTML tables, the distance (in pixel) between lines.}

\item{column_labels}{Labels of columns for HTML tables. If \code{NULL}, automatic
column names are generated. See 'Examples'.}
}
\value{
Invisibly returns the original input object.
}
\description{
A \code{print()}-method for objects from \code{\link[=compare_parameters]{compare_parameters()}}.
}
\section{Global Options to Customize Messages and Tables when Printing}{

The \code{verbose} argument can be used to display or silence messages and
warnings for the different functions in the \strong{parameters} package. However,
some messages providing additional information can be displayed or suppressed
using \code{options()}:
\itemize{
\item \code{parameters_info}: \code{options(parameters_info = TRUE)} will override the
\code{include_info} argument in \code{model_parameters()} and always show the model
summary for non-mixed models.
\item \code{parameters_mixed_info}: \code{options(parameters_mixed_info = TRUE)} will
override the \code{include_info} argument in \code{model_parameters()} for mixed
models, and will then always show the model summary.
\item \code{parameters_cimethod}: \code{options(parameters_cimethod = TRUE)} will show the
additional information about the approximation method used to calculate
confidence intervals and p-values. Set to \code{FALSE} to hide this message when
printing \code{model_parameters()} objects.
\item \code{parameters_exponentiate}: \code{options(parameters_exponentiate = TRUE)} will
show the additional information on how to interpret coefficients of models
with log-transformed response variables or with log-/logit-links when the
\code{exponentiate} argument in \code{model_parameters()} is not \code{TRUE}. Set this option
to \code{FALSE} to hide this message when printing \code{model_parameters()} objects.
}

There are further options that can be used to modify the default behaviour
for printed outputs:
\itemize{
\item \code{parameters_labels}: \code{options(parameters_labels = TRUE)} will use variable
and value labels for pretty names, if data is labelled. If no labels
available, default pretty names are used.
\item \code{parameters_interaction}: \verb{options(parameters_interaction = <character>)}
will replace the interaction mark (by default, \code{*}) with the related character.
\item \code{parameters_select}: \verb{options(parameters_select = <value>)} will set the
default for the \code{select} argument. See argument's documentation for available
options.
\item \code{easystats_table_width}: \verb{options(easystats_table_width = <value>)} will
set the default width for tables in text-format, i.e. for most of the outputs
printed to console. If not specified, tables will be adjusted to the current
available width, e.g. of the of the console (or any other source for textual
output, like markdown files). The argument \code{table_width} can also be used in
most \code{print()} methods to specify the table width as desired.
\item \code{insight_use_symbols}: \code{options(insight_use_symbols = TRUE)} will try to
print unicode-chars for symbols as column names, wherever possible (e.g.,
\ifelse{html}{\out{&omega;}}{\eqn{\omega}} instead of \code{Omega}).
}
}

\examples{
\dontshow{if (require("gt", quietly = TRUE)) withAutoprint(\{ # examplesIf}
\donttest{
data(iris)
lm1 <- lm(Sepal.Length ~ Species, data = iris)
lm2 <- lm(Sepal.Length ~ Species + Petal.Length, data = iris)

# custom style
result <- compare_parameters(lm1, lm2, select = "{estimate}{stars} ({se})")
print(result)

# custom style, in HTML
result <- compare_parameters(lm1, lm2, select = "{estimate}<br>({se})|{p}")
print_html(result)
}
\dontshow{\}) # examplesIf}
}
