% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facet-.R, R/facet-grid-.R, R/facet-null.R,
%   R/facet-wrap.R
\docType{data}
\name{Facet}
\alias{Facet}
\alias{FacetGrid}
\alias{FacetNull}
\alias{FacetWrap}
\title{Facets}
\description{
All \verb{facet_*()} functions returns a \code{Facet} object or an object of a
\code{Facet} subclass. This object describes how to assign data to different
panels, how to apply positional scales and how to lay out the panels, once
rendered.
}
\details{
Extending facets can range from the simple modifications of current facets,
to very laborious rewrites with a lot of \code{\link[gtable:gtable]{gtable()}}
manipulation.For some examples of both, please see the extension vignette.
The object and its parameters are chaperoned by the \link{Layout} class.

\code{Facet} subclasses, like other extendible ggproto classes, have a range
of methods that can be modified. Some of these are required for all new
subclasses, while other only need to be modified if need arises.

The required methods are:
\itemize{
\item \code{compute_layout}
\item \code{map_data()}
\item \code{draw_panels()} or its subsidiaries:
\itemize{
\item \code{init_gtable()}
\item \code{attach_axes()}
\item \code{attach_strips()}
}
}

In addition to the methods above, it can be useful to override the default
behaviour of one or more of the following methods:
\itemize{
\item \code{setup_params()}
\item \code{init_scales()}
\item \code{train_scale()}
\item \code{finish_data()}
\item \code{draw_back()}, \code{draw_front()} or \code{draw_labels()}
}

All extension methods receive the content of the params field as the params
argument, so the constructor function will generally put all relevant
information into this field.
}
\section{Fields}{

\describe{
\item{\code{shink}}{A scalar boolean which when \code{TRUE}, will shrink scales to
fit output statistics rather than raw data. If \code{FALSE}, will only include
raw data before statistical summary. By exception this is not part of the
\code{params} field.}

\item{\code{params}}{A named list of parameters populated by the constructor
function.}

\item{\code{setup_params}}{\strong{Description}

A function method for modifying or checking the parameters based on the
data. The default method includes a \code{.possible_columns} variable giving
column names.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Facet$setup_params(data, params)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A list of data frames. The first item is the global data,
which is followed by layer data in subsequent items.}
\item{\code{params}}{A list of current parameters.}
}

\strong{Value}

A list of parameters}

\item{\code{setup_data}}{\strong{Description}

A function method for modifying or checking the data prior to adding
defaults. The default method returns data unaltered.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Facet$setup_data(data, params)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A list of data frames. The first item is the global data,
which is followed by layer data in subsequent items.}
\item{\code{params}}{A list of parameters coming from the \code{setup_params()}
method.}
}

\strong{Value}

A list of data frames of the same length as the \code{data} argument}

\item{\code{compute_layout}}{\strong{Description}

A function method for creating the correspondence between faceting
variable levels, panels and position scales. It places panels like cells
in a matrix.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Facet$compute_layout(data, params)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A list of data frames. The first item is the global data,
which is followed by layer data in subsequent items.}
\item{\code{params}}{A list of parameters coming from the \code{setup_params()}
method.}
}

\strong{Value}

A data frame with 1 row per panel, containing at least integer columns
\code{ROW}, \code{COL}, \code{PANEL}, \code{SCALE_X} and \code{SCALE_Y}. Can contain additional
information in terms of columns, typically faceting variables.}

\item{\code{map_data}}{\strong{Description}

A function method for to create the \code{PANEL} variable in layer data. The
\code{PANEL} variable is a special variable that tracks the relationship between
rows in the layer data and the panels described in the \code{layout} input.

In addition, #' this function may copy or discard rows as needed, for
example when adding margins in FacetGrid.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Facet$map_data(data, layout, params)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A list of data frames containing layer data.}
\item{\code{layout}}{A data frame computed by the \code{compute_layout()} method.
Typically contains the faceting variables, \code{ROW}, \code{COL}, \code{PANEL},
\code{SCALE_X} and \code{SCALE_Y} variables.}
\item{\code{params}}{A list of parameters coming from the \code{setup_params()}
method.}
}

\strong{Value}

A list of data frames containing layer data including a \code{PANEL} variable.}

\item{\code{init_scales}}{\strong{Description}

A function method for initialising position scales. Given a prototype scale
for \code{x} and \code{y}, creates layout specific scales to accommodate
the relationships between panels and scales. By default, the prototype
scales are cloned for each \code{SCALE_X} and \code{SCALE_Y} level. The function is
called separately; once for \code{x} and once for \code{y}.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Facet$init_scales(layout, x_scale, y_scale, params)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{layout}}{A data frame computed by the \code{compute_layout()} method.
Typically contains the faceting variables, \code{ROW}, \code{COL}, \code{PANEL},
\code{SCALE_X} and \code{SCALE_Y} variables.}
\item{\code{x_scale},\code{y_scale}}{A position scale for the \code{x} and \code{y}
aesthetics respectively.}
\item{\code{params}}{A list of parameters coming from the \code{setup_params()}
method.}
}

\strong{Value}

A named list with \code{x} and \code{y} elements containing a list of panel scales
for each \code{SCALE_X} and/or \code{SCALE_Y} level respectively.}

\item{\code{train_scales}}{\strong{Description}

A function method for training position scales. The default trains each
scale on the data related to its panels.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Facet$train_scales(x_scales, y_scales, layout, data, params)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{x_scales},\code{y_scales}}{A list of panel scales for each \code{SCALE_X}
and \code{SCALE_Y} level respectively.}
\item{\code{layout}}{A data frame computed by the \code{compute_layout()} method.
Typically contains the faceting variables, \code{ROW}, \code{COL}, \code{PANEL},
\code{SCALE_X} and \code{SCALE_Y} variables.}
\item{\code{data}}{A list of data frames containing layer data.}
\item{\code{params}}{A list of parameters coming from the \code{setup_params()}
method.}
}

\strong{Value}

Nothing, this method is called for its side-effect of training the scales.}

\item{\code{setup_panel_params}}{\strong{Description}

A function method as a hook to give facets input over panel parameters. By
default, returns panel parameters unaltered.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Facet$setup_panel_params(panel_params, coord, ...)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{panel_params}}{A named list of view scales, ranges and other
optional parameters from \code{Coord$setup_panel_params()}.}
\item{\code{coord}}{A \verb{<Coord>} ggproto object.}
\item{\code{...}}{Currently not in use. For future expansion.}
}

\strong{Value}

A list of panel parameters.}

\item{\code{finish_data}}{\strong{Description}

A function method as a hook for making last-minute modifications to layer
data before it is rendered by Geoms. The default is to not modify the data.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Facet$finish_data(data, layout, x_scales, y_scales, params)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A data frame containing layer data of a single layer.}
\item{\code{layout}}{A data frame computed by the \code{compute_layout()} method.
Typically contains the faceting variables, \code{ROW}, \code{COL}, \code{PANEL},
\code{SCALE_X} and \code{SCALE_Y} variables.}
\item{\code{x_scales},\code{y_scales}}{A list of panel scales for each \code{SCALE_X}
and \code{SCALE_Y} level respectively.}
\item{\code{params}}{A list of parameters coming from the \code{setup_params()}
method.}
}

\strong{Value}

A data frame containing layer data.}

\item{\code{draw_panel_content}}{\strong{Description}

A function method to assemble the panel contents. It delegates the
\code{draw_back()} and \code{draw_front()} methods, as well as \code{Coord$draw_panel()}.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Facet$draw_panel_content(
  panels,
  layout,
  x_scales,
  y_scales,
  ranges,
  coord,
  theme,
  params,
  ...
)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{panels}}{A list parallel to layers. Each element is another list
with grobs for each panel, generated by \code{Layer$draw_geom()}.}
\item{\code{layout}}{A data frame computed by the \code{compute_layout()} method.
Typically contains the faceting variables, \code{ROW}, \code{COL}, \code{PANEL},
\code{SCALE_X} and \code{SCALE_Y} variables.}
\item{\code{x_scales},\code{y_scales}}{A list of panel scales for each \code{SCALE_X}
and \code{SCALE_Y} level respectively.}
\item{\code{ranges}}{A list of panel parameters from the
\code{setup_panel_params()} augmented with position guides.}
\item{\code{coord}}{A \verb{<Coord>} ggproto object.}
\item{\code{data}}{A list of data frames containing layer data.}
\item{\code{theme}}{A \link[=complete_theme]{complete theme} object.}
\item{\code{params}}{A list of parameters coming from the \code{setup_params()}
method.}
\item{\code{...}}{Currently not in use.}
}

\strong{Value}

A list of grobs, one for each level of the \code{PANEL} layout variable. Grob
can be \code{zeroGrob()} to draw nothing.}

\item{\code{draw_back,draw_front}}{\strong{Description}

A function method draw facet background (back) and foreground (front) for
panels. The front and back will sandwich the grobs created by layers. The
default methods draw nothing.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Facet$draw_back(data, layout, x_scales, y_scales, theme, params)
Facet$draw_front(data, layout, x_scales, y_scales, theme, params)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{data}}{A list of data frames containing layer data.}
\item{\code{layout}}{A data frame computed by the \code{compute_layout()} method.
Typically contains the faceting variables, \code{ROW}, \code{COL}, \code{PANEL},
\code{SCALE_X} and \code{SCALE_Y} variables.}
\item{\code{x_scales},\code{y_scales}}{A list of panel scales for each \code{SCALE_X}
and \code{SCALE_Y} level respectively.}
\item{\code{theme}}{A \link[=complete_theme]{complete theme} object.}
\item{\code{params}}{A list of parameters coming from the \code{setup_params()}
method.}
}

\strong{Value}

A list of grobs, one for each level of the \code{PANEL} layout variable. Grob
can be \code{zeroGrob()} to draw nothing.}

\item{\code{draw_panels}}{\strong{Description}

A function method that orchestrates the majority of facet drawing. It is
responsible for assembling a gtable with panel content decorated with axes
and strips. The resulting gtable is the basis for the plot in its entirety.
It delegates these tasks to the \code{init_gtable()}, \code{attach_axes()} and
\code{attach_strips()} methods.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Facet$draw_panels(
  panels,
  layout,
  x_scales,
  y_scales,
  ranges,
  coord,
  data,
  theme,
  params
)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{panels}}{A list of grobs, one per panel.}
\item{\code{layout}}{A data frame computed by the \code{compute_layout()} method.
Typically contains the faceting variables, \code{ROW}, \code{COL}, \code{PANEL},
\code{SCALE_X} and \code{SCALE_Y} variables.}
\item{\code{x_scales},\code{y_scales}}{A list of panel scales for each \code{SCALE_X}
and \code{SCALE_Y} level respectively.}
\item{\code{ranges}}{A list of panel parameters from the
\code{setup_panel_params()} augmented with position guides.}
\item{\code{coord}}{A \verb{<Coord>} ggproto object.}
\item{\code{data}}{A list of data frames containing layer data.}
\item{\code{theme}}{A \link[=complete_theme]{complete theme} object.}
\item{\code{params}}{A list of parameters coming from the \code{setup_params()}
method.}
}

\strong{Value}

A \code{\link[gtable:gtable]{gtable}} object.}

\item{\code{init_gtable}}{\strong{Description}

A function method that initiates a gtable object containing panels set
at the appropriate \code{ROW} and \code{COL} cells from the layout. The panels are
separated by the \verb{panel.spacing.\{x/y\}} spacing.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Facet$init_gtable(panels, layout, theme, ranges, params, aspect_ratio)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{panels}}{A list of grobs, one per panel.}
\item{\code{layout}}{A data frame computed by the \code{compute_layout()} method.
Typically contains the faceting variables, \code{ROW}, \code{COL}, \code{PANEL},
\code{SCALE_X} and \code{SCALE_Y} variables.}
\item{\code{theme}}{A \link[=complete_theme]{complete theme} object.}
\item{\code{ranges}}{A list of panel parameters from the
\code{setup_panel_params()} augmented with position guides.}
\item{\code{aspect_ratio}}{A scalar numeric for the panel aspect ratio or
\code{NULL} for no aspect ratio.}
}

\strong{Value}

A \code{\link[gtable:gtable]{gtable}} object containing panel grobs prefixed with
\code{"panel"}.}

\item{\code{attach_axes}}{\strong{Description}

A function method that renders position guides (axes) and attaches these
to the gtable with panels. The default method returns the gtable unaltered.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Facet$attach_axes(table, layout, ranges, coord, theme, params)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{table}}{A \code{\link[gtable:gtable]{gtable}} object populated with panels from the
\code{init_gtable()} method.}
\item{\code{layout}}{A data frame computed by the \code{compute_layout()} method.
Typically contains the faceting variables, \code{ROW}, \code{COL}, \code{PANEL},
\code{SCALE_X} and \code{SCALE_Y} variables.}
\item{\code{ranges}}{A list of panel parameters from the
\code{setup_panel_params()} augmented with position guides.}
\item{\code{coord}}{A \verb{<Coord>} ggproto object.}
\item{\code{theme}}{A \link[=complete_theme]{complete theme} object.}
\item{\code{params}}{A list of parameters coming from the \code{setup_params()}
method.}
}

\strong{Value}

A \code{\link[gtable:gtable]{gtable}} object.}

\item{\code{attach_strips}}{\strong{Description}

A function method that renders strips and attaches these to the gtable
with panels and axes. The \code{format_strip_labels()} method is used to format
the strip text. The default method returns the gtable unaltered.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Facet$attach_strips(table, layout, ranges, coord, theme, params)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{table}}{A \code{\link[gtable:gtable]{gtable}} object from the \code{attach_axes()}
method.}
\item{\code{layout}}{A data frame computed by the \code{compute_layout()} method.
Typically contains the faceting variables, \code{ROW}, \code{COL}, \code{PANEL},
\code{SCALE_X} and \code{SCALE_Y} variables.}
\item{\code{params}}{A list of parameters coming from the \code{setup_params()}
method.}
\item{\code{theme}}{A \link[=complete_theme]{complete theme} object.}
}

\strong{Value}

A \code{\link[gtable:gtable]{gtable}} object.}

\item{\code{format_strip_labels}}{\strong{Description}

A function method that formats the text for strips. It is used in the
\code{attach_strips} methods, but also the \code{get_strip_labels()} function.
The default method returns \code{NULL}.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Facet$format_strip_labels(layout, params)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{layout}}{A data frame computed by the \code{compute_layout()} method.
Typically contains the faceting variables, \code{ROW}, \code{COL}, \code{PANEL},
\code{SCALE_X} and \code{SCALE_Y} variables.}
\item{\code{params}}{A list of parameters coming from the \code{setup_params()}
method.}
}

\strong{Value}

A list containing a data frame with strip labels.}

\item{\code{set_panel_size}}{\strong{Description}

A function method that enforces the \code{panel.widths} and \code{panel.heights}
theme settings.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Facet$set_panel_size(table, theme)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{table}}{A \code{\link[gtable:gtable]{gtable}} object populated by the
\code{draw_panels()} method.}
\item{\code{theme}}{A \link[=complete_theme]{complete theme} object.}
}

\strong{Value}

The \code{table} object, optionally with different \code{widths} and \code{heights}
properties.}

\item{\code{attach_axes}}{\strong{Description}

A function method that renders axis titles and adds them to the gtable.
The default is to add one title at each side depending on the position
and presence of axes.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Facet$draw_labels(
  panels,
  layout,
  x_scales,
  y_scales,
  ranges,
  coord,
  data,
  theme,
  labels,
  params
)
}\if{html}{\out{</div>}}

\strong{Arguments}
\describe{
\item{\code{panels}}{A \code{\link[gtable:gtable]{gtable}} object initiated by the
\code{draw_panels()} method.}
\item{\code{layout}}{A data frame computed by the \code{compute_layout()} method.
Typically contains the faceting variables, \code{ROW}, \code{COL}, \code{PANEL},
\code{SCALE_X} and \code{SCALE_Y} variables.}
\item{\code{x_scales},\code{y_scales}}{A list of panel scales for each \code{SCALE_X}
and \code{SCALE_Y} level respectively.}
\item{\code{ranges}}{A list of panel parameters from the
\code{setup_panel_params()} augmented with position guides.}
\item{\code{coord}}{A \verb{<Coord>} ggproto object.}
\item{\code{data}}{A list of data frames containing layer data.}
\item{\code{theme}}{A \link[=complete_theme]{complete theme} object.}
\item{\code{labels}}{A named list containing an \code{x} list and \code{y} list. The
\code{x} and \code{y} lists have \code{primary} and \code{secondary} labels.}
\item{\code{params}}{A list of parameters coming from the \code{setup_params()}
method.}
}

\strong{Value}

A \code{\link[gtable:gtable]{gtable}} object.}

\item{\code{vars}}{\strong{Description}

A function method that returns the names of faceting variables. The
default method returns an character vector with 0 length.

\strong{Usage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Facet$vars()
}\if{html}{\out{</div>}}

\strong{Value}

A character vector}
}}

\section{Conventions}{


The object name that a new class is assigned to is typically the same as the
class name. Facet class names are in UpperCamelCase and start with the
\verb{Facet*} prefix, like \code{FacetNew}.

A constructor function is usually paired with a Facet class. The constructor
copies the facet class and populates the \code{params} field. The constructor
function name should take the Facet class name and be formatted with
snake_case, so that \code{FacetNew} becomes \code{facet_new()}.
}

\examples{
# Please see extension vignette
NULL
}
\seealso{
The the \href{https://ggplot2-book.org/extensions#new-facets}{new facets section} of the online ggplot2 book.

Run \code{vignette("extending-ggplot2")}, in particular the "Creating a
new faceting" section.

Other Layout components: 
\code{\link{Coord}},
\code{\link{Layout}}
}
\concept{Layout components}
\keyword{datasets}
\keyword{internal}
