% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/requirePackages.R
\name{requirePackages}
\alias{requirePackages}
\title{Require some packages}
\usage{
requirePackages(
  packs,
  min.versions = NULL,
  why = "",
  stop = TRUE,
  suppress.warnings = FALSE,
  default.method = "attach"
)
}
\arguments{
\item{packs}{[\code{character}]\cr
Names of packages.
If a package name is prefixed with \dQuote{!}, it will be attached using \code{\link[base]{require}}.
If a package name is prefixed with \dQuote{_}, its namespace will be loaded using \code{\link[base]{requireNamespace}}.
If there is no prefix, argument \code{default.method} determines how to deal with package loading.}

\item{min.versions}{[\code{character}]\cr
A char vector specifying required minimal version numbers for a subset of packages in \code{packs}.
Must be named and all names must be in \code{packs}.
The only exception is when \code{packs} is only a single string, then you are allowed to pass
an unnamed version string here.
Default is \code{NULL}, meaning no special version requirements}

\item{why}{[\code{character(1)}]\cr
Short string explaining why packages are required.
Default is an empty string.}

\item{stop}{[\code{logical(1)}]\cr
Should an exception be thrown for missing packages?
Default is \code{TRUE}.}

\item{suppress.warnings}{[\code{logical(1)}]\cr
Should warnings be supressed while requiring?
Default is \code{FALSE}.}

\item{default.method}{[\code{character(1)}]\cr
If the packages are not explicitly prefixed with \dQuote{!} or \dQuote{_},
this arguments determines the default. Possible values are \dQuote{attach} and
\dQuote{load}.
Note that the default is \dQuote{attach}, but this might/will change in a future version, so
please make sure to always explicitly set this.}
}
\value{
[\code{logical}]. Named logical vector describing which packages could be loaded (with required version).
  Same length as \code{packs}.
}
\description{
Packages are loaded either via \code{\link{requireNamespace}} or \code{\link{require}}.

If some packages could not be loaded and \code{stop} is \code{TRUE}
the following exception is thrown:
\dQuote{For <why> please install the following packages: <missing packages>}.
If \code{why} is \code{NULL} the message is:
\dQuote{Please install the following packages: <missing packages>}.
}
\examples{
requirePackages(c("BBmisc", "base"), why = "BBmisc example")
}
