# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._auto_scale_vcores_operations import (
    build_create_request,
    build_delete_request,
    build_get_request,
    build_list_by_resource_group_request,
    build_list_by_subscription_request,
    build_update_request,
)

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class AutoScaleVCoresOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.powerbidedicated.aio.PowerBIDedicated`'s
        :attr:`auto_scale_vcores` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(self, resource_group_name: str, vcore_name: str, **kwargs: Any) -> _models.AutoScaleVCore:
        """Gets details about the specified auto scale v-core.

        :param resource_group_name: The name of the Azure Resource group of which a given
         PowerBIDedicated capacity is part. This name must be at least 1 character in length, and no
         more than 90. Required.
        :type resource_group_name: str
        :param vcore_name: The name of the auto scale v-core. It must be a minimum of 3 characters, and
         a maximum of 63. Required.
        :type vcore_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AutoScaleVCore or the result of cls(response)
        :rtype: ~azure.mgmt.powerbidedicated.models.AutoScaleVCore
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2021-01-01"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.AutoScaleVCore]

        request = build_get_request(
            resource_group_name=resource_group_name,
            vcore_name=vcore_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.get.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("AutoScaleVCore", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBIDedicated/autoScaleVCores/{vcoreName}"}  # type: ignore

    @overload
    async def create(
        self,
        resource_group_name: str,
        vcore_name: str,
        v_core_parameters: _models.AutoScaleVCore,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AutoScaleVCore:
        """Provisions the specified auto scale v-core based on the configuration specified in the request.

        :param resource_group_name: The name of the Azure Resource group of which a given
         PowerBIDedicated capacity is part. This name must be at least 1 character in length, and no
         more than 90. Required.
        :type resource_group_name: str
        :param vcore_name: The name of the auto scale v-core. It must be a minimum of 3 characters, and
         a maximum of 63. Required.
        :type vcore_name: str
        :param v_core_parameters: Contains the information used to provision the auto scale v-core.
         Required.
        :type v_core_parameters: ~azure.mgmt.powerbidedicated.models.AutoScaleVCore
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AutoScaleVCore or the result of cls(response)
        :rtype: ~azure.mgmt.powerbidedicated.models.AutoScaleVCore
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create(
        self,
        resource_group_name: str,
        vcore_name: str,
        v_core_parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AutoScaleVCore:
        """Provisions the specified auto scale v-core based on the configuration specified in the request.

        :param resource_group_name: The name of the Azure Resource group of which a given
         PowerBIDedicated capacity is part. This name must be at least 1 character in length, and no
         more than 90. Required.
        :type resource_group_name: str
        :param vcore_name: The name of the auto scale v-core. It must be a minimum of 3 characters, and
         a maximum of 63. Required.
        :type vcore_name: str
        :param v_core_parameters: Contains the information used to provision the auto scale v-core.
         Required.
        :type v_core_parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AutoScaleVCore or the result of cls(response)
        :rtype: ~azure.mgmt.powerbidedicated.models.AutoScaleVCore
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create(
        self,
        resource_group_name: str,
        vcore_name: str,
        v_core_parameters: Union[_models.AutoScaleVCore, IO],
        **kwargs: Any
    ) -> _models.AutoScaleVCore:
        """Provisions the specified auto scale v-core based on the configuration specified in the request.

        :param resource_group_name: The name of the Azure Resource group of which a given
         PowerBIDedicated capacity is part. This name must be at least 1 character in length, and no
         more than 90. Required.
        :type resource_group_name: str
        :param vcore_name: The name of the auto scale v-core. It must be a minimum of 3 characters, and
         a maximum of 63. Required.
        :type vcore_name: str
        :param v_core_parameters: Contains the information used to provision the auto scale v-core. Is
         either a model type or a IO type. Required.
        :type v_core_parameters: ~azure.mgmt.powerbidedicated.models.AutoScaleVCore or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AutoScaleVCore or the result of cls(response)
        :rtype: ~azure.mgmt.powerbidedicated.models.AutoScaleVCore
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2021-01-01"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.AutoScaleVCore]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(v_core_parameters, (IO, bytes)):
            _content = v_core_parameters
        else:
            _json = self._serialize.body(v_core_parameters, "AutoScaleVCore")

        request = build_create_request(
            resource_group_name=resource_group_name,
            vcore_name=vcore_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.create.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("AutoScaleVCore", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBIDedicated/autoScaleVCores/{vcoreName}"}  # type: ignore

    @distributed_trace_async
    async def delete(  # pylint: disable=inconsistent-return-statements
        self, resource_group_name: str, vcore_name: str, **kwargs: Any
    ) -> None:
        """Deletes the specified auto scale v-core.

        :param resource_group_name: The name of the Azure Resource group of which a given
         PowerBIDedicated capacity is part. This name must be at least 1 character in length, and no
         more than 90. Required.
        :type resource_group_name: str
        :param vcore_name: The name of the auto scale v-core. It must be a minimum of 3 characters, and
         a maximum of 63. Required.
        :type vcore_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2021-01-01"]
        cls = kwargs.pop("cls", None)  # type: ClsType[None]

        request = build_delete_request(
            resource_group_name=resource_group_name,
            vcore_name=vcore_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.delete.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBIDedicated/autoScaleVCores/{vcoreName}"}  # type: ignore

    @overload
    async def update(
        self,
        resource_group_name: str,
        vcore_name: str,
        v_core_update_parameters: _models.AutoScaleVCoreUpdateParameters,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AutoScaleVCore:
        """Updates the current state of the specified auto scale v-core.

        :param resource_group_name: The name of the Azure Resource group of which a given
         PowerBIDedicated capacity is part. This name must be at least 1 character in length, and no
         more than 90. Required.
        :type resource_group_name: str
        :param vcore_name: The name of the auto scale v-core. It must be a minimum of 3 characters, and
         a maximum of 63. Required.
        :type vcore_name: str
        :param v_core_update_parameters: Request object that contains the updated information for the
         auto scale v-core. Required.
        :type v_core_update_parameters:
         ~azure.mgmt.powerbidedicated.models.AutoScaleVCoreUpdateParameters
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AutoScaleVCore or the result of cls(response)
        :rtype: ~azure.mgmt.powerbidedicated.models.AutoScaleVCore
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self,
        resource_group_name: str,
        vcore_name: str,
        v_core_update_parameters: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AutoScaleVCore:
        """Updates the current state of the specified auto scale v-core.

        :param resource_group_name: The name of the Azure Resource group of which a given
         PowerBIDedicated capacity is part. This name must be at least 1 character in length, and no
         more than 90. Required.
        :type resource_group_name: str
        :param vcore_name: The name of the auto scale v-core. It must be a minimum of 3 characters, and
         a maximum of 63. Required.
        :type vcore_name: str
        :param v_core_update_parameters: Request object that contains the updated information for the
         auto scale v-core. Required.
        :type v_core_update_parameters: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AutoScaleVCore or the result of cls(response)
        :rtype: ~azure.mgmt.powerbidedicated.models.AutoScaleVCore
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update(
        self,
        resource_group_name: str,
        vcore_name: str,
        v_core_update_parameters: Union[_models.AutoScaleVCoreUpdateParameters, IO],
        **kwargs: Any
    ) -> _models.AutoScaleVCore:
        """Updates the current state of the specified auto scale v-core.

        :param resource_group_name: The name of the Azure Resource group of which a given
         PowerBIDedicated capacity is part. This name must be at least 1 character in length, and no
         more than 90. Required.
        :type resource_group_name: str
        :param vcore_name: The name of the auto scale v-core. It must be a minimum of 3 characters, and
         a maximum of 63. Required.
        :type vcore_name: str
        :param v_core_update_parameters: Request object that contains the updated information for the
         auto scale v-core. Is either a model type or a IO type. Required.
        :type v_core_update_parameters:
         ~azure.mgmt.powerbidedicated.models.AutoScaleVCoreUpdateParameters or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AutoScaleVCore or the result of cls(response)
        :rtype: ~azure.mgmt.powerbidedicated.models.AutoScaleVCore
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2021-01-01"]
        content_type = kwargs.pop("content_type", _headers.pop("Content-Type", None))  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.AutoScaleVCore]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(v_core_update_parameters, (IO, bytes)):
            _content = v_core_update_parameters
        else:
            _json = self._serialize.body(v_core_update_parameters, "AutoScaleVCoreUpdateParameters")

        request = build_update_request(
            resource_group_name=resource_group_name,
            vcore_name=vcore_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.update.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("AutoScaleVCore", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    update.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBIDedicated/autoScaleVCores/{vcoreName}"}  # type: ignore

    @distributed_trace
    def list_by_resource_group(
        self, resource_group_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.AutoScaleVCore"]:
        """Gets all the auto scale v-cores for the given resource group.

        :param resource_group_name: The name of the Azure Resource group of which a given
         PowerBIDedicated capacity is part. This name must be at least 1 character in length, and no
         more than 90. Required.
        :type resource_group_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either AutoScaleVCore or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.powerbidedicated.models.AutoScaleVCore]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2021-01-01"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.AutoScaleVCoreListResult]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_by_resource_group_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_by_resource_group.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("AutoScaleVCoreListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_by_resource_group.metadata = {"url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.PowerBIDedicated/autoScaleVCores"}  # type: ignore

    @distributed_trace
    def list_by_subscription(self, **kwargs: Any) -> AsyncIterable["_models.AutoScaleVCore"]:
        """Lists all the auto scale v-cores for the given subscription.

        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either AutoScaleVCore or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.powerbidedicated.models.AutoScaleVCore]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )  # type: Literal["2021-01-01"]
        cls = kwargs.pop("cls", None)  # type: ClsType[_models.AutoScaleVCoreListResult]

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_by_subscription_request(
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    template_url=self.list_by_subscription.metadata["url"],
                    headers=_headers,
                    params=_params,
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                request = _convert_request(request)
                request.url = self._client.format_url(request.url)  # type: ignore
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("AutoScaleVCoreListResult", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    list_by_subscription.metadata = {"url": "/subscriptions/{subscriptionId}/providers/Microsoft.PowerBIDedicated/autoScaleVCores"}  # type: ignore
