; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-- | FileCheck %s -check-prefix=X87
; RUN: llc < %s -mtriple=i686-- -mattr=-x87 | FileCheck %s -check-prefixes=NOX87,NOSSE-NOX87
; RUN: llc < %s -mtriple=i686-- -mattr=-x87,-sse2 | FileCheck %s -check-prefixes=NOX87,NOSSE-NOX87
; RUN: llc < %s -mtriple=i686-- -mattr=-x87,+sse2 | FileCheck %s -check-prefixes=NOX87,SSE-NOX87

define float @f1(float %a, float %b) nounwind {
; X87-LABEL: f1:
; X87:       # %bb.0: # %entry
; X87-NEXT:    flds {{[0-9]+}}(%esp)
; X87-NEXT:    retl
;
; NOSSE-NOX87-LABEL: f1:
; NOSSE-NOX87:       # %bb.0: # %entry
; NOSSE-NOX87-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE-NOX87-NEXT:    retl
;
; SSE-NOX87-LABEL: f1:
; SSE-NOX87:       # %bb.0: # %entry
; SSE-NOX87-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NOX87-NEXT:    movd %xmm0, %eax
; SSE-NOX87-NEXT:    retl
entry:
  ret float %b
}

define double @f2(double %a, double %b) nounwind {
; X87-LABEL: f2:
; X87:       # %bb.0: # %entry
; X87-NEXT:    fldl {{[0-9]+}}(%esp)
; X87-NEXT:    retl
;
; NOX87-LABEL: f2:
; NOX87:       # %bb.0: # %entry
; NOX87-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOX87-NEXT:    movl {{[0-9]+}}(%esp), %edx
; NOX87-NEXT:    retl
entry:
  ret double %b
}

define x86_fp80 @f3(x86_fp80 %a, x86_fp80 %b) nounwind {
; X87-LABEL: f3:
; X87:       # %bb.0: # %entry
; X87-NEXT:    fldt {{[0-9]+}}(%esp)
; X87-NEXT:    retl
;
; NOX87-LABEL: f3:
; NOX87:       # %bb.0: # %entry
; NOX87-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOX87-NEXT:    movl {{[0-9]+}}(%esp), %edx
; NOX87-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; NOX87-NEXT:    retl
entry:
  ret x86_fp80 %b
}

define float @f4(float %a, float %b) nounwind {
; X87-LABEL: f4:
; X87:       # %bb.0: # %entry
; X87-NEXT:    flds {{[0-9]+}}(%esp)
; X87-NEXT:    fadds {{[0-9]+}}(%esp)
; X87-NEXT:    retl
;
; NOSSE-NOX87-LABEL: f4:
; NOSSE-NOX87:       # %bb.0: # %entry
; NOSSE-NOX87-NEXT:    pushl {{[0-9]+}}(%esp)
; NOSSE-NOX87-NEXT:    pushl {{[0-9]+}}(%esp)
; NOSSE-NOX87-NEXT:    calll __addsf3
; NOSSE-NOX87-NEXT:    addl $8, %esp
; NOSSE-NOX87-NEXT:    retl
;
; SSE-NOX87-LABEL: f4:
; SSE-NOX87:       # %bb.0: # %entry
; SSE-NOX87-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NOX87-NEXT:    addss {{[0-9]+}}(%esp), %xmm0
; SSE-NOX87-NEXT:    movd %xmm0, %eax
; SSE-NOX87-NEXT:    retl
entry:
  %0 = fadd float %a, %b
  ret float %0
}

define double @f5(double %a, double %b) nounwind {
; X87-LABEL: f5:
; X87:       # %bb.0: # %entry
; X87-NEXT:    fldl {{[0-9]+}}(%esp)
; X87-NEXT:    faddl {{[0-9]+}}(%esp)
; X87-NEXT:    retl
;
; NOSSE-NOX87-LABEL: f5:
; NOSSE-NOX87:       # %bb.0: # %entry
; NOSSE-NOX87-NEXT:    pushl {{[0-9]+}}(%esp)
; NOSSE-NOX87-NEXT:    pushl {{[0-9]+}}(%esp)
; NOSSE-NOX87-NEXT:    pushl {{[0-9]+}}(%esp)
; NOSSE-NOX87-NEXT:    pushl {{[0-9]+}}(%esp)
; NOSSE-NOX87-NEXT:    calll __adddf3
; NOSSE-NOX87-NEXT:    addl $16, %esp
; NOSSE-NOX87-NEXT:    retl
;
; SSE-NOX87-LABEL: f5:
; SSE-NOX87:       # %bb.0: # %entry
; SSE-NOX87-NEXT:    pushl %ebp
; SSE-NOX87-NEXT:    movl %esp, %ebp
; SSE-NOX87-NEXT:    andl $-8, %esp
; SSE-NOX87-NEXT:    subl $8, %esp
; SSE-NOX87-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE-NOX87-NEXT:    addsd 16(%ebp), %xmm0
; SSE-NOX87-NEXT:    movsd %xmm0, (%esp)
; SSE-NOX87-NEXT:    movl (%esp), %eax
; SSE-NOX87-NEXT:    movl {{[0-9]+}}(%esp), %edx
; SSE-NOX87-NEXT:    movl %ebp, %esp
; SSE-NOX87-NEXT:    popl %ebp
; SSE-NOX87-NEXT:    retl
entry:
  %0 = fadd double %a, %b
  ret double %0
}

define x86_fp80 @f6(x86_fp80 %a, x86_fp80 %b) nounwind {
; X87-LABEL: f6:
; X87:       # %bb.0: # %entry
; X87-NEXT:    fldt {{[0-9]+}}(%esp)
; X87-NEXT:    fldt {{[0-9]+}}(%esp)
; X87-NEXT:    faddp %st, %st(1)
; X87-NEXT:    retl
;
; NOX87-LABEL: f6:
; NOX87:       # %bb.0: # %entry
; NOX87-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; NOX87-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; NOX87-NEXT:    pushl %ecx
; NOX87-NEXT:    pushl {{[0-9]+}}(%esp)
; NOX87-NEXT:    pushl {{[0-9]+}}(%esp)
; NOX87-NEXT:    pushl %eax
; NOX87-NEXT:    pushl {{[0-9]+}}(%esp)
; NOX87-NEXT:    pushl {{[0-9]+}}(%esp)
; NOX87-NEXT:    calll __addxf3
; NOX87-NEXT:    addl $24, %esp
; NOX87-NEXT:    movzwl %cx, %ecx
; NOX87-NEXT:    retl
entry:
  %0 = fadd x86_fp80 %a, %b
  ret x86_fp80 %0
}

define {float, float, float} @f7(float %a, float %b) nounwind {
; X87-LABEL: f7:
; X87:       # %bb.0: # %entry
; X87-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X87-NEXT:    flds {{[0-9]+}}(%esp)
; X87-NEXT:    flds {{[0-9]+}}(%esp)
; X87-NEXT:    fstps 8(%eax)
; X87-NEXT:    fsts 4(%eax)
; X87-NEXT:    fstps (%eax)
; X87-NEXT:    retl $4
;
; NOSSE-NOX87-LABEL: f7:
; NOSSE-NOX87:       # %bb.0: # %entry
; NOSSE-NOX87-NEXT:    movl {{[0-9]+}}(%esp), %eax
; NOSSE-NOX87-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; NOSSE-NOX87-NEXT:    movl %eax, %edx
; NOSSE-NOX87-NEXT:    retl
;
; SSE-NOX87-LABEL: f7:
; SSE-NOX87:       # %bb.0: # %entry
; SSE-NOX87-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NOX87-NEXT:    movd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE-NOX87-NEXT:    movd %xmm0, %eax
; SSE-NOX87-NEXT:    movd %xmm0, %edx
; SSE-NOX87-NEXT:    movd %xmm1, %ecx
; SSE-NOX87-NEXT:    retl
entry:
  %0 = insertvalue {float, float, float} undef, float %a, 0
  %1 = insertvalue {float, float, float} %0, float %a, 1
  %2 = insertvalue {float, float, float} %1, float %b, 2
  ret {float, float, float} %2
}

define x86_fp80 @f8(i64 %a) nounwind {
; X87-LABEL: f8:
; X87:       # %bb.0: # %entry
; X87-NEXT:    fildll {{[0-9]+}}(%esp)
; X87-NEXT:    retl
;
; NOX87-LABEL: f8:
; NOX87:       # %bb.0: # %entry
; NOX87-NEXT:    pushl {{[0-9]+}}(%esp)
; NOX87-NEXT:    pushl {{[0-9]+}}(%esp)
; NOX87-NEXT:    calll __floatdixf
; NOX87-NEXT:    addl $8, %esp
; NOX87-NEXT:    movzwl %cx, %ecx
; NOX87-NEXT:    retl
entry:
  %0 = sitofp i64 %a to x86_fp80
  ret x86_fp80 %0
}

define i32 @f9(x86_fp80 %a) nounwind {
; X87-LABEL: f9:
; X87:       # %bb.0: # %entry
; X87-NEXT:    subl $8, %esp
; X87-NEXT:    fldt {{[0-9]+}}(%esp)
; X87-NEXT:    fnstcw (%esp)
; X87-NEXT:    movzwl (%esp), %eax
; X87-NEXT:    orl $3072, %eax # imm = 0xC00
; X87-NEXT:    movw %ax, {{[0-9]+}}(%esp)
; X87-NEXT:    fldcw {{[0-9]+}}(%esp)
; X87-NEXT:    fistpl {{[0-9]+}}(%esp)
; X87-NEXT:    fldcw (%esp)
; X87-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X87-NEXT:    addl $8, %esp
; X87-NEXT:    retl
;
; NOX87-LABEL: f9:
; NOX87:       # %bb.0: # %entry
; NOX87-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; NOX87-NEXT:    pushl %eax
; NOX87-NEXT:    pushl {{[0-9]+}}(%esp)
; NOX87-NEXT:    pushl {{[0-9]+}}(%esp)
; NOX87-NEXT:    calll __fixxfsi
; NOX87-NEXT:    addl $12, %esp
; NOX87-NEXT:    retl
entry:
  %0 = fptosi x86_fp80 %a to i32
  ret i32 %0
}
