//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
	"net/http"
	"net/url"
	"regexp"
)

// IntegrationRuntimeStatusServer is a fake server for instances of the armsynapse.IntegrationRuntimeStatusClient type.
type IntegrationRuntimeStatusServer struct {
	// Get is the fake for method IntegrationRuntimeStatusClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, workspaceName string, integrationRuntimeName string, options *armsynapse.IntegrationRuntimeStatusClientGetOptions) (resp azfake.Responder[armsynapse.IntegrationRuntimeStatusClientGetResponse], errResp azfake.ErrorResponder)
}

// NewIntegrationRuntimeStatusServerTransport creates a new instance of IntegrationRuntimeStatusServerTransport with the provided implementation.
// The returned IntegrationRuntimeStatusServerTransport instance is connected to an instance of armsynapse.IntegrationRuntimeStatusClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewIntegrationRuntimeStatusServerTransport(srv *IntegrationRuntimeStatusServer) *IntegrationRuntimeStatusServerTransport {
	return &IntegrationRuntimeStatusServerTransport{srv: srv}
}

// IntegrationRuntimeStatusServerTransport connects instances of armsynapse.IntegrationRuntimeStatusClient to instances of IntegrationRuntimeStatusServer.
// Don't use this type directly, use NewIntegrationRuntimeStatusServerTransport instead.
type IntegrationRuntimeStatusServerTransport struct {
	srv *IntegrationRuntimeStatusServer
}

// Do implements the policy.Transporter interface for IntegrationRuntimeStatusServerTransport.
func (i *IntegrationRuntimeStatusServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "IntegrationRuntimeStatusClient.Get":
		resp, err = i.dispatchGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (i *IntegrationRuntimeStatusServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if i.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/integrationRuntimes/(?P<integrationRuntimeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getStatus`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	integrationRuntimeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("integrationRuntimeName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := i.srv.Get(req.Context(), resourceGroupNameParam, workspaceNameParam, integrationRuntimeNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).IntegrationRuntimeStatusResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
