//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsql_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/DatabaseVulnerabilityAssessmentScansExecute.json
func ExampleDatabaseVulnerabilityAssessmentScansClient_BeginInitiateScan() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDatabaseVulnerabilityAssessmentScansClient().BeginInitiateScan(ctx, "vulnerabilityassessmenttest-4711", "vulnerabilityassessmenttest-6411", "testdb", armsql.VulnerabilityAssessmentNameDefault, "scan01", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/DatabaseVulnerabilityAssessmentScanRecordsListByDatabase.json
func ExampleDatabaseVulnerabilityAssessmentScansClient_NewListByDatabasePager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDatabaseVulnerabilityAssessmentScansClient().NewListByDatabasePager("vulnerabilityassessmenttest-4711", "vulnerabilityassessmenttest-6411", "testdb", armsql.VulnerabilityAssessmentNameDefault, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.VulnerabilityAssessmentScanRecordListResult = armsql.VulnerabilityAssessmentScanRecordListResult{
		// 	Value: []*armsql.VulnerabilityAssessmentScanRecord{
		// 		{
		// 			Name: to.Ptr("scan001"),
		// 			Type: to.Ptr("Microsoft.Sql/servers/databases/vulnerabilityAssessments/scans"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityassessmenttest-4799/providers/Microsoft.Sql/servers/vulnerabilityassessmenttest-6440/databases/testdb/vulnerabilityAssessments/default/scans/scan001"),
		// 			Properties: &armsql.VulnerabilityAssessmentScanRecordProperties{
		// 				EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-12T17:47:06.000Z"); return t}()),
		// 				Errors: []*armsql.VulnerabilityAssessmentScanError{
		// 				},
		// 				NumberOfFailedSecurityChecks: to.Ptr[int32](9),
		// 				ScanID: to.Ptr("scan001"),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-12T17:45:06.000Z"); return t}()),
		// 				State: to.Ptr(armsql.VulnerabilityAssessmentScanStatePassed),
		// 				StorageContainerPath: to.Ptr("https://myaccount.blob.core.windows.net/vulnerability-assessment"),
		// 				TriggerType: to.Ptr(armsql.VulnerabilityAssessmentScanTriggerTypeOnDemand),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("scan002"),
		// 			Type: to.Ptr("Microsoft.Sql/servers/databases/vulnerabilityAssessments/scans"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityassessmenttest-4799/providers/Microsoft.Sql/servers/vulnerabilityassessmenttest-6440/databases/testdb/vulnerabilityAssessments/default/scans/scan002"),
		// 			Properties: &armsql.VulnerabilityAssessmentScanRecordProperties{
		// 				EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-12T17:47:06.000Z"); return t}()),
		// 				Errors: []*armsql.VulnerabilityAssessmentScanError{
		// 				},
		// 				NumberOfFailedSecurityChecks: to.Ptr[int32](9),
		// 				ScanID: to.Ptr("scan002"),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-12T17:45:06.000Z"); return t}()),
		// 				State: to.Ptr(armsql.VulnerabilityAssessmentScanStateFailed),
		// 				StorageContainerPath: to.Ptr("https://myaccount.blob.core.windows.net/vulnerability-assessment"),
		// 				TriggerType: to.Ptr(armsql.VulnerabilityAssessmentScanTriggerTypeRecurring),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("scan003"),
		// 			Type: to.Ptr("Microsoft.Sql/servers/databases/vulnerabilityAssessments/scans"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityassessmenttest-4799/providers/Microsoft.Sql/servers/vulnerabilityassessmenttest-6440/databases/testdb/vulnerabilityAssessments/default/scans/scan003"),
		// 			Properties: &armsql.VulnerabilityAssessmentScanRecordProperties{
		// 				EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-12T17:47:06.000Z"); return t}()),
		// 				Errors: []*armsql.VulnerabilityAssessmentScanError{
		// 					{
		// 						Code: to.Ptr("StorageNotFound"),
		// 						Message: to.Ptr("Storage not found"),
		// 				}},
		// 				NumberOfFailedSecurityChecks: to.Ptr[int32](0),
		// 				ScanID: to.Ptr("scan003"),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-12T17:45:06.000Z"); return t}()),
		// 				State: to.Ptr(armsql.VulnerabilityAssessmentScanStateFailedToRun),
		// 				StorageContainerPath: to.Ptr("https://myaccount.blob.core.windows.net/vulnerability-assessment"),
		// 				TriggerType: to.Ptr(armsql.VulnerabilityAssessmentScanTriggerTypeRecurring),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/DatabaseVulnerabilityAssessmentScanRecordsGet.json
func ExampleDatabaseVulnerabilityAssessmentScansClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDatabaseVulnerabilityAssessmentScansClient().Get(ctx, "vulnerabilityassessmenttest-4711", "vulnerabilityassessmenttest-6411", "testdb", armsql.VulnerabilityAssessmentNameDefault, "scan001", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VulnerabilityAssessmentScanRecord = armsql.VulnerabilityAssessmentScanRecord{
	// 	Name: to.Ptr("scan001"),
	// 	Type: to.Ptr("Microsoft.Sql/servers/databases/vulnerabilityAssessments/scans"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityassessmenttest-4799/providers/Microsoft.Sql/servers/vulnerabilityassessmenttest-6440/databases/testdb/vulnerabilityAssessments/default/scans/scan001"),
	// 	Properties: &armsql.VulnerabilityAssessmentScanRecordProperties{
	// 		EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-12T17:47:06.000Z"); return t}()),
	// 		Errors: []*armsql.VulnerabilityAssessmentScanError{
	// 		},
	// 		NumberOfFailedSecurityChecks: to.Ptr[int32](9),
	// 		ScanID: to.Ptr("scan001"),
	// 		StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-12T17:45:06.000Z"); return t}()),
	// 		State: to.Ptr(armsql.VulnerabilityAssessmentScanStatePassed),
	// 		StorageContainerPath: to.Ptr("https://myaccount.blob.core.windows.net/vulnerability-assessment"),
	// 		TriggerType: to.Ptr(armsql.VulnerabilityAssessmentScanTriggerTypeOnDemand),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/DatabaseVulnerabilityAssessmentScanExport.json
func ExampleDatabaseVulnerabilityAssessmentScansClient_Export() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDatabaseVulnerabilityAssessmentScansClient().Export(ctx, "vulnerabilityassessmenttest-4799", "vulnerabilityassessmenttest-6440", "testdb", armsql.VulnerabilityAssessmentNameDefault, "scan001", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DatabaseVulnerabilityAssessmentScansExport = armsql.DatabaseVulnerabilityAssessmentScansExport{
	// 	Name: to.Ptr("scan001"),
	// 	Type: to.Ptr("Microsoft.Sql/servers/databases/vulnerabilityAssessments/scans/export"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityassessmenttest-4799/providers/Microsoft.Sql/servers/vulnerabilityassessmenttest-6440/databases/testdb/vulnerabilityAssessments/default/scans/scan001/export"),
	// 	Properties: &armsql.DatabaseVulnerabilityAssessmentScanExportProperties{
	// 		ExportedReportLocation: to.Ptr("https://myaccount.blob.core.windows.net/vulnerabilityAssessment/vulnerabilityassessmenttest-6440/testdb/scan001.xlsx"),
	// 	},
	// }
}
