<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text" encoding="UTF8"/>

<xsl:template match="/">
/********************************************************************\
 * iso-4217-currencies.c -- list of currencies gnucash understands  *
 *                                                                  *
 * ATTENTION: this file is autogenerated based on                   *
 *            iso-4217-currencies.xml                               *
 *                                                                  *
 * If you need any modifications in this file, please update the    *
 * xml source file (or the xsl translation file depending on the    *
 * kind of change required) instead.                                *
 *                                                                  *
 * Copyright (C) 2015 Geert Janssens &lt;geert@kobaltwit.be&gt;           *
 *                                                                  *
 * This program is free software; you can redistribute it and/or    *
 * modify it under the terms of the GNU General Public License as   *
 * published by the Free Software Foundation; either version 2 of   *
 * the License, or (at your option) any later version.              *
 *                                                                  *
 * This program is distributed in the hope that it will be useful,  *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of   *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the    *
 * GNU General Public License for more details.                     *
 *                                                                  *
 * You should have received a copy of the GNU General Public License*
 * along with this program; if not, contact:                        *
 *                                                                  *
 * Free Software Foundation           Voice:  +1-617-542-5942       *
 * 51 Franklin Street, Fifth Floor    Fax:    +1-617-542-2652       *
 * Boston, MA  02110-1301,  USA       gnu@gnu.org                   *
 *                                                                  *
\********************************************************************/

<xsl:for-each select="//currency">
  {
    const char *fullname = "<xsl:value-of select="@fullname"/>";
    gnc_commodity *c = gnc_commodity_new(book,
                                         CUR_I18N(fullname),
                                         "<xsl:value-of select="@namespace"/>",
                                         "<xsl:value-of select="@isocode"/>",
                                         "<xsl:value-of select="@exchange-code"/>",
                                         <xsl:value-of select="@smallest-fraction"/>);
    if(!c) {
      PWARN("failed to create commodity for currency %s", fullname);
    } else {
      if(!gnc_commodity_table_insert(table, c)) {
        PWARN("failed to insert %s into commodity table", fullname);
      }
    }
    gnc_commodity_set_default_symbol(c, "<xsl:value-of select="@local-symbol"/>");
  }
</xsl:for-each>
</xsl:template>
</xsl:stylesheet>
